/*****************************************************
Project : 16X16 ƮƮ Ȯ庸(LK-DOTM16)(ATmega128)
Version : 
Date    : 2013-07-06
Author  : Kyung Nam Lee
Company : LKӺ 
Comments: ~, A~Z ڸ ϴ α׷̴. 
Chip type               : ATmega128
Program type            : Application
AVR Core Clock frequency: 16.000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 1024
*****************************************************/

#include <mega128.h>
#include <delay.h>
#define A0  PORTD.0
#define A1  PORTD.1
#define A2  PORTD.2
#define A3  PORTD.3
#define Data_Red PORTD.4
#define Data_Green PORTD.5
#define Clk  PORTD.6
#define LE PORTD.7
#define OE PORTB.0 
flash unsigned int string[][16]={
0x00,0x1800,0x18fe,0x1980,0x1980,0x1980,0x7980,0x1980,0x18c0,0x18c0,0x1860,0x1838,0x180e,0x1800,0x00,0x00, //
0x00,0x1800,0x1806,0x1806,0x1806,0x1806,0x7806,0x1806,0x1806,0x1806,0x1806,0x1806,0x1bfc,0x1800,0x00,0x00, //
0x00,0x1800,0x19fc,0x1806,0x1806,0x1806,0x7806,0x1806,0x1806,0x1806,0x1806,0x1806,0x1bfc,0x1800,0x00,0x00, //
0x00,0x1800,0x18fe,0x1980,0x1980,0x1980,0x7980,0x18fc,0x1806,0x1806,0x1806,0x1806,0x1ffc,0x1800,0x00,0x00, //
0x00,0x1800,0x19fe,0x1986,0x1986,0x1986,0x7986,0x1986,0x1986,0x1986,0x1986,0x1986,0x19fe,0x1800,0x00,0x00, //
0x00,0x1800,0x1986,0x1986,0x1986,0x1986,0x79fe,0x1986,0x1986,0x1986,0x1986,0x1986,0x18fc,0x1800,0x00,0x00, //
0x00,0x1800,0x1860,0x1860,0x1860,0x1860,0x7860,0x18f0,0x18f0,0x1998,0x1998,0x1b0c,0x1b06,0x1800,0x00,0x00, //
0x00,0x1800,0x1878,0x18cc,0x1986,0x1986,0x7986,0x1986,0x1986,0x1986,0x1986,0x18cc,0x1878,0x1800,0x00,0x00, //
0x00,0x1800,0x1bfc,0x1860,0x1860,0x1860,0x7870,0x18f0,0x18f0,0x1998,0x1998,0x1b0c,0x1b06,0x1800,0x00,0x00, //
0x00,0x1800,0x19f8,0x1800,0x1bfc,0x1860,0x7860,0x1870,0x18f0,0x1998,0x1998,0x1b0c,0x1b06,0x1800,0x00,0x00, //
0x00,0x1800,0x18fc,0x1980,0x1980,0x1980,0x79fe,0x1980,0x18c0,0x18c0,0x1860,0x1838,0x180e,0x1800,0x00,0x00, //ī
0x00,0x1800,0x19fc,0x1806,0x1806,0x1806,0x7806,0x18fe,0x1806,0x1806,0x1806,0x1806,0x1ffc,0x1800,0x00,0x00, //Ÿ
0x00,0x1800,0x19fe,0x1800,0x18cc,0x18cc,0x78cc,0x18cc,0x18cc,0x18cc,0x18cc,0x1878,0x1bfe,0x1800,0x00,0x00, //
0x00,0x1800,0x18f8,0x1800,0x1bfe,0x1800,0x78f8,0x198c,0x198c,0x198c,0x198c,0x198c,0x18f8,0x1800,0x00,0x00, //
0x00,0x00,0x380,0x380,0x6c0,0x6c0,0x6c0,0xc60,0xc60,0xfe0,0x1830,0x1830,0x1830,0x00,0x00,0x00, //A
0x00,0x00,0x7f0,0xc30,0xc30,0xc30,0x630,0x7f0,0xc30,0x1830,0x1830,0xc30,0x7f0,0x00,0x00,0x00, //B
0x00,0x00,0x7c0,0xc60,0x1830,0x30,0x30,0x30,0x30,0x30,0x1830,0xc60,0x7c0,0x00,0x00,0x00, //C
0x00,0x00,0x3f0,0x630,0xc30,0x1830,0x1830,0x1830,0x1830,0x1830,0xc30,0x630,0x3f0,0x00,0x00,0x00, //D
0x00,0x00,0xff0,0x30,0x30,0x30,0x30,0x7f0,0x30,0x30,0x30,0x30,0xff0,0x00,0x00,0x00, //E
0x00,0x00,0xff0,0x30,0x30,0x30,0x30,0x7f0,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00, //F
0x00,0x00,0xf80,0x18c0,0x3060,0x30,0x30,0x3e30,0x3030,0x3030,0x3060,0x38c0,0x3f80,0x00,0x00,0x00, //G
0x00,0x00,0x1830,0x1830,0x1830,0x1830,0x1830,0x1ff0,0x1830,0x1830,0x1830,0x1830,0x1830,0x00,0x00,0x00, //H
0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00, //I
0x00,0x00,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x198,0x198,0xf0,0x00,0x00,0x00, //J
0x00,0x00,0xc30,0x630,0x330,0x1b0,0xf0,0x1f0,0x330,0x330,0x630,0xc30,0xc30,0x00,0x00,0x00, //K
0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xff0,0x00,0x00,0x00, //L
0x00,0x00,0x3018,0x3018,0x3838,0x3838,0x3c78,0x3c78,0x36d8,0x36d8,0x3398,0x3398,0x3018,0x00,0x00,0x00, //M
0x00,0x00,0xc30,0xc70,0xc70,0xcf0,0xcf0,0xdb0,0xdb0,0xf30,0xf30,0xe30,0xe30,0x00,0x00,0x00, //N
0x00,0x00,0x7c0,0xc60,0x1830,0x3018,0x3018,0x3018,0x3018,0x3018,0x1830,0xc60,0x7c0,0x00,0x00,0x00, //O
0x00,0x00,0x7f0,0xc30,0x1830,0x1830,0xc30,0x7f0,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00, //P
0x00,0x00,0x7c0,0xc60,0x1830,0x3018,0x3018,0x3018,0x3018,0x3318,0x1e30,0xc60,0x1fc0,0x00,0x00,0x00, //Q
0x00,0x00,0x7f0,0xc30,0x1830,0x1830,0xc30,0x7f0,0xc30,0x1830,0x1830,0x1830,0x1830,0x00,0x00,0x00, //R
0x00,0x00,0x7c0,0xc60,0x1830,0x30,0xe0,0x780,0xc00,0x1800,0x1830,0xc60,0x7c0,0x00,0x00,0x00, //S
0x00,0x00,0xff0,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x00,0x00,0x00, //T
0x00,0x00,0x1830,0x1830,0x1830,0x1830,0x1830,0x1830,0x1830,0x1830,0x1830,0xc60,0x7c0,0x00,0x00,0x00, //U
0x00,0x00,0xc30,0xc30,0xc30,0x660,0x660,0x660,0x3c0,0x3c0,0x3c0,0x180,0x180,0x00,0x00,0x00, //V
0x00,0x00,0x6186,0x6186,0x6186,0x33cc,0x33cc,0x33cc,0x1e78,0x1e78,0x1e78,0xc30,0xc30,0x00,0x00,0x00, //W
0x00,0x00,0xc30,0xc30,0x660,0x660,0x3c0,0x180,0x3c0,0x660,0x660,0xc30,0xc30,0x00,0x00,0x00, //X
0x00,0x00,0xc30,0xc30,0x660,0x660,0x3c0,0x180,0x180,0x180,0x180,0x180,0x180,0x00,0x00,0x00, //Y
0x00,0x00,0xff0,0xc00,0x600,0x300,0x300,0x180,0xc0,0xc0,0x60,0x30,0xff0,0x00,0x00,0x00, //Z
};
// Timer 0 overflow interrupt service routine
unsigned char flag_cnt=0;
#include <stdio.h>
volatile unsigned int Move_cnt=15;
volatile unsigned int Move_cnt2=0;
unsigned char key_input=0;
volatile unsigned int up_cnt=0;
#define string_stop_time_value 2000
#define string_moving_speed_value 50

#define up_down 1
#define left_right 2

static unsigned int str_speed_cnt=0;  

unsigned char move_motion=0;

bit toggle_char=0;
bit toggle_flag=0;
#define in1 0
#define in2 1  //  ƮƮ 1 ƮƮ 2 ģ.
#define in3 2
#define in4 3
#define in5 4
#define in6 5
#define in7 6
static unsigned int Dot_char_cnt=0; //ƮƮ ǥ   ī!   
//Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
{
    static unsigned int toggle_cnt=0;     
    static unsigned int cnt=0;
    cnt++;
    if(cnt==500)
    {     
    cnt=0;
    }  
    if(toggle_char){ 
     toggle_cnt++;
     if(toggle_cnt>1000)
     {                
        toggle_char=0;
        toggle_cnt=0;
        toggle_flag^=1; 
        move_motion=0;
       
        }               
     }
     key_input=PINC&0x0f; 
     str_speed_cnt++;
    if(str_speed_cnt>string_moving_speed_value) //ڰ 500 ӹ  Ʈ !
    {     
              
        str_speed_cnt=0; //string moving speed counter   
        Move_cnt--;
        Move_cnt2++;     
        up_cnt++; // Ʒ ̵ ӵ īƮ    
    if(Move_cnt==0||Move_cnt2==15)
    {         
        Move_cnt2=0;                  
        Move_cnt=15;       
        move_motion++; //          
        if(move_motion==2)
        {
        move_motion=0; 
        Dot_char_cnt++;
        flag_cnt++;  
        if(flag_cnt==3)
        {
        flag_cnt=0;  
        }  
        }
    } 

    }  
    TCNT0|=0x06;
}
void row_dynamic()
{
    static unsigned int str_cnt=0;       

        switch(str_cnt)//ROW SHIFT!
        {
        case 0:A0=0; A1=0; A2=0; A3=0;break; 
        case 1:A0=1; A1=0; A2=0; A3=0; break; 
        case 2:A0=0; A1=1; A2=0; A3=0; break; 
        case 3:A0=1; A1=1; A2=0; A3=0; break; 
        case 4:A0=0; A1=0; A2=1; A3=0; break; 
        case 5:A0=1; A1=0; A2=1; A3=0; break; 
        case 6:A0=0; A1=1; A2=1; A3=0; break; 
        case 7:A0=1; A1=1; A2=1; A3=0; break; 
        case 8:A0=0; A1=0; A2=0; A3=1; break; 
        case 9:A0=1; A1=0; A2=0; A3=1; break; 
        case 10:A0=0; A1=1; A2=0; A3=1; break; 
        case 11:A0=1; A1=1; A2=0; A3=1; break; 
        case 12:A0=0; A1=0; A2=1; A3=1; break; 
        case 13:A0=1; A1=0; A2=1; A3=1; break; 
        case 14:A0=0; A1=1; A2=1; A3=1; break; 
        case 15:A0=1; A1=1; A2=1; A3=1; break; 
        } 
  
    ++str_cnt; 
    if(str_cnt==16)
    {
    str_cnt=0;   
    }         
}
void shift_Driver(unsigned char out)
{

    unsigned char clk=0;          
    for(clk=0;clk<8;clk++){ //8Ʈ ͸ 1Ʈ ƮͿ Է        
		if(out&(0x80>>clk))
		{              
        switch(flag_cnt) { // LED  !
        case 0:Data_Green=0;Data_Red=1; break;
        case 1:Data_Green=1;Data_Red=0; break;    
        case 2:Data_Green=1;Data_Red=1; break;   
        } 
		}      
        else {
         Data_Green=0; 
         Data_Red=0;
        }      
        Clk=1;delay_us(1);Clk=0; 
    }  
}

void ActivePulse()
{    
    LE=1; delay_us(1); LE=0;// ġ 
    OE=0;
    delay_us(500); // OUTPUT ENABLE 
}

void dot1_display_shift(unsigned int first)
{
            static unsigned int i_cnt=0;  
            register unsigned int buff[16]={0};
            register unsigned char high=0;
            register unsigned char low=0;
            register unsigned int i=0;
                for(i_cnt=0;i_cnt<16;i_cnt++){ //ڰ ʿ ߾, ߾ӿ   귯 ǥ     
                    if(move_motion==in1) 
                    {                          
                      buff[i_cnt]=string[first][i_cnt]<<Move_cnt; // 1st String Dot1 in  
                    }             
                    if(move_motion==in2)  
                    {  
                                     
                      buff[i_cnt]=string[first][i_cnt]>>Move_cnt2; // 1st String Dot1 Out    
                    } 
                }   
                for(i=0;i<16;i++)
                {    
                high=(buff[i]>>8);
                low =(buff[i]&0xff);
                shift_Driver(high);               
                shift_Driver(low);                                     
                row_dynamic();
                ActivePulse();
                }  
}      
void main(void)
{
DDRD=0xff;
DDRB=0x01;
/*
 A0  PORTD.0
 A1  PORTD.1
 A2  PORTD.2
 A3  PORTD.3
 Data_Red PORTD.4
 Data_Green PORTD.5
 Clk  PORTD.6
 LE PORTD.7
 OE PORTB.0 
*/

TCCR0=0x04;
TCNT0=0x06;
TIMSK=0x01;
// Global enable interrupts
#asm("sei")
toggle_char=0;
while(1)
{
 dot1_display_shift(Dot_char_cnt);    
 if(Dot_char_cnt==40)
 Dot_char_cnt=0;
}
}                                                                                                                                                                                                                                                                                                                               
